
var imageArray = ["images/image1.jpg", "images/image2.jpg", "images/image3.jpg", "images/image4.jpg", "images/image5.jpg", "images/image6.jpg"];
var currImage = 0;




schedule("window", initSlideshow)




function initSlideshow()
{
	centrePage();
	
	var buttonPrevious = document.getElementById("buttonPrevious");
	var buttonNext = document.getElementById("buttonNext");
	
	buttonPrevious.onclick = clickButtonPrevious;
	buttonNext.onclick = clickButtonNext;
	
	return true;
}




function centrePage()
{
	var page = document.getElementById("page");
	
	page.style.marginLeft = -parseInt(parseInt(page.style.width) / 2) + "px";
	page.style.marginTop = -parseInt(page.offsetHeight / 2) + "px";
	
	return true;
}




function clickButtonPrevious()
{
	this.blur();
	
	currImage--;
	
	if (currImage < 0)
	{
		currImage = imageArray.length - 1;
	}

	imageOff("previous");
	
	setTimeout("checkImageOff()", 1000);
	
	return false;
}




function clickButtonNext()
{
	this.blur();
	
	currImage++;
	
	if (currImage >= imageArray.length)
	{
		currImage = 0;
	}
	
	imageOff("next");
	
	setTimeout("checkImageOff()", 1000)
	
	return false;
}




function imageOff(direction)
{
	var contentInner2 = document.getElementById("contentInner2");
	var contentInner2Height = contentInner2.offsetHeight;
	var clipHeight = 10;
	
	document.getElementsByTagName("body")[0].className = "empty";
	
	contentInner2.getElementsByTagName("img")[0].style.visibility = "hidden";
	
	var slices = false;
	var images = document.getElementsByTagName("img");
	
	for (var i = 0; i < images.length; i++)
	{
		if (images[i].className.classExists("slice"))
		{
			var delay = parseInt(Math.random() * 500);

			images[i].objRef.moveOff(delay);
			slices = true;
		}
	}
	
	if (!slices)
	{
		for (var i = 0; i < contentInner2Height; i += clipHeight)
		{
			var delay = parseInt(Math.random() * 500);
			var oldImage = currImage - 1;

			if (direction == "next" && oldImage < 0)
			{
				oldImage = imageArray.length - 1;
			}
			else if (direction == "previous")
			{
				oldImage = currImage + 1;
				
				if (oldImage >= imageArray.length)
				{
					oldImage = 0;
				}
			}
			
			new slice("off", imageArray[oldImage], clipHeight, i, -75, delay);
		}
	}
	
	return true;
}




function checkImageOff()
{
	var images = document.getElementsByTagName("img");
	var finished = true;
	
	for (var i = 0; i < images.length; i++)
	{
		if (images[i].className.classExists("slice"))
		{
			finished = false;
			
			break;
		}
	}
	
	if (!finished)
	{
		setTimeout("checkImageOff()", 25);
	}
	else
	{
		resizeFrame();
	}
	
	return true;
}




function resizeFrame(width, height, iteration)
{
	var page = document.getElementById("page");
	var pageWidth = page.offsetWidth;
	var contentInner2 = document.getElementById("contentInner2");
	var contentInner2Height = contentInner2.offsetHeight;
	var maxIteration = 20;
	
	if (typeof width == "undefined")
	{
		dimensions = getImageDimensions(imageArray[currImage]);
		
		if (dimensions[0] == 0)
		{
			setTimeout("resizeFrame()", 25);
			
			return false;
		}
		
		width = dimensions[0] + 38;
		height = dimensions[1];
		iteration = 0;
	}
	
	if (iteration < maxIteration)
	{
		page.style.width = pageWidth + parseInt((width - pageWidth) * (1 / (maxIteration - iteration))) + "px";
		
		contentInner2.style.height = contentInner2Height + parseInt((height - contentInner2Height) * (1 / (maxIteration - iteration))) + "px";
		
		centrePage();
		
		iteration++;
		
		setTimeout("resizeFrame(" + width + ", " + height + ", " + iteration + ")", 25);
	}
	else
	{
		page.style.width = width + "px";
		contentInner2.style.height = height + "px";
		imageOn();
		
		setTimeout("checkImageOn()", 1000)
	}
	
	return true;
}




function imageOn()
{
	var contentInner2 = document.getElementById("contentInner2");
	var contentInner2Height = contentInner2.offsetHeight;
	var clipHeight = 10;
	
	document.getElementsByTagName("body")[0].className = "empty";
	
	contentInner2.getElementsByTagName("img")[0].style.visibility = "hidden";
	
	for (var i = 0; i < contentInner2Height; i += clipHeight)
	{
		var delay = parseInt(Math.random() * 500);

		new slice("on", imageArray[currImage], clipHeight, i, -75, delay);
	}
	
	return true;
}




function checkImageOn()
{
	var contentInner2 = document.getElementById("contentInner2");
	var contentPosition = getPosition(contentInner2);
	var images = document.getElementsByTagName("img");
	var finished = true;
	
	for (var i = 0; i < images.length; i++)
	{
		if (images[i].className.classExists("slice") && parseInt(images[i].style.left) != contentPosition[0])
		{
			finished = false;
			
			break;
		}
	}
	
	if (!finished)
	{
		setTimeout("checkImageOn()", 25);
	}
	else
	{
		setFrame();
	}
	
	return true;
}




function setFrame()
{
	var contentInner2 = document.getElementById("contentInner2");
	var contentImage = contentInner2.getElementsByTagName("img")[0];
	var images = document.getElementsByTagName("img");

	contentImage.setAttribute("src", imageArray[currImage]);

	document.getElementsByTagName("body")[0].className = "";
	
	return true;
}




function slice(status, imagePath, clipHeight, clipStart, interval, delay)
{
	var contentInner2 = document.getElementById("contentInner2");
	var contentPosition = getPosition(contentInner2);
	var contentWidth = contentInner2.offsetWidth;
	var self = this;
	
	this.interval = interval;
	this.image = document.createElement("img");
	this.image.objRef = this;
	this.image.className = "slice";
	this.image.setAttribute("src", imagePath);
	this.image.style.position = "absolute";
	
	if (status == "off")
	{
		this.image.style.left = contentPosition[0] + "px";
	}
	else
	{
		this.image.style.left = document.documentElement.clientWidth + "px";
	}
	
	this.image.style.top = contentPosition[1] + "px";
	this.image.style.clip = "rect(" + clipStart + "px, " + contentWidth + "px, " + (clipStart + clipHeight) + "px, 0)";
	this.image = document.getElementsByTagName("body")[0].appendChild(this.image);
	
	if (status == "off")
	{
		setTimeout(function(){self.moveOff()}, delay);
	}
	else
	{
		setTimeout(function(){self.moveOn()}, delay);
	}
	
	return true;
}




slice.prototype.moveOff = function(delay)
{
	var self = this;
	
	if (typeof delay != "undefined")
	{
		setTimeout(function(){self.moveOff()}, delay);
		
		return false;
	}
	
	var currLeft = parseInt(this.image.style.left);
	
	if (currLeft > 0 - this.image.offsetWidth)
	{
		this.image.style.left = currLeft + this.interval + "px";
	
		setTimeout(function(){self.moveOff()}, 25);
	}
	else
	{
		this.image.parentNode.removeChild(this.image);
	}
	
	return true;
}




slice.prototype.moveOn = function()
{
	var contentInner2 = document.getElementById("contentInner2");
	var contentPosition = getPosition(contentInner2);
	var self = this;
	var currLeft = parseInt(this.image.style.left);
	
	if (currLeft < contentPosition[0] - this.interval)
	{
		this.image.style.left = contentPosition[0] + "px";
	}
	else
	{
		this.image.style.left = parseInt(this.image.style.left) + this.interval + "px";
	
		setTimeout(function(){self.moveOn()}, 25);
	}
	
	return true;
}




function getImageDimensions(imagePath)
{
	var preloadedImage = document.getElementById("preloadedImage");
	

	if (preloadedImage == null)
	{
		preloadedImage = document.createElement("img");
		preloadedImage.id = "preloadedImage";
		preloadedImage.setAttribute("src", imagePath);
		preloadedImage.style.position = "absolute";
		preloadedImage.style.left = "-10000px";
		preloadedImage.style.top = "-10000px";
		preloadedImage = document.getElementsByTagName("body")[0].appendChild(preloadedImage);
	}
	
	var dimensions = [preloadedImage.clientWidth, preloadedImage.clientHeight];
	
	if (dimensions[0] != 0)
	{
		preloadedImage.parentNode.removeChild(preloadedImage);
	}
	
	return dimensions;
}